#include "CameraCBuffer.hlsli"

cbuffer ModelConstantBuffer : register(b1)
{
	matrix WorldViewProjectionMatrix;
	matrix PrevWVPMatrix;
	matrix InvWVPMatrix;
	matrix NormalMatrix;
	float3 Emission;
};


struct PSInput
{
	float4 PositionViewportS : SV_Position;
	float4 Color : Color0;
	float4 Normal : Normal;
	float2 Velocity : VELOCITY;
};

struct PSOutput
{
	float4 target0 : SV_Target0; // Forward lit rendertarget
	float2 target1 : SV_Target1; // Velocity map rendertarget
};

PSOutput main(PSInput input)
{
	PSOutput output = (PSOutput)0;

	//---------- Calculate forward lighting ----------

	// Direction from surface to light
	//const float3 lightDir = normalize(float3(1, 1, -1));
	const float3 lightDir = normalize(float3(0, 1, -1));

	// Illumination from the sun (around 1000 lux on an overcast day)
	const float3 noonIlluminance = 1000 * float3(0.33, 0.33, 0.33);

	// Twilight (around 5 lux)
	const float3 nightIlluminance = 5 * float3(0.33, 0.33, 0.33);

	const float3 curLighting = noonIlluminance;
	//const float3 curLighting = nightIlluminance;
	
	float3 normal = normalize(input.Normal.xyz);

	// Ratio of light being reflected
	float lightDotNormal = max(dot(normal, lightDir), 0);
	float3 diffuse = lightDotNormal * input.Color.rgb * curLighting;

	// Add ground reflected diffuse to make it look a bit better
	const float3 groundDir = float3(0, -1, 0);
	// The average ground reflection is about 20% of the global irradiance
	// http://en.wikipedia.org/wiki/Irradiance
	const float groundReflectance = 0.2;
	float groundDotNormal = max(dot(normal, groundDir), 0);
	float3 groundDiffuse = groundDotNormal * groundReflectance * input.Color.rgb * curLighting;
	
	float4 litColor = float4(diffuse + groundDiffuse, input.Color.a);

	// Add emissive light
	litColor.rgb += Emission;
	
	//---------- Store results ----------
	output.target0 = litColor;
	output.target1 = input.Velocity;
	
	return output;
	
}
